#!/bin/sh

DEFAULT_ARCH="$(uname -m || arch)"

get_lib_dir() {
  if [ "$DEFAULT_ARCH" = "i386" ]; then
    LIBDIR=lib/i386-linux-gnu
  elif [ "$DEFAULT_ARCH" = "amd64" ]; then
    LIBDIR=lib/x86_64-linux-gnu
  elif [ "$DEFAULT_ARCH" = "i686" ]; then
    LIBDIR=lib/i386-linux-gnu
  else
    echo Unknown CPU Architecture: "$DEFAULT_ARCH"
    exit 1
  fi
}

LIBUDEV_0=libudev.so.0
LIBUDEV_1=libudev.so.1

add_udev_symlinks() {
  get_lib_dir
  if [ -f "/$LIBDIR/$LIBUDEV_0" -o -f "/usr/$LIBDIR/$LIBUDEV_0" -o -f "/lib/$LIBUDEV_0" ]; then
    return 0
  fi

  if [ -f "/$LIBDIR/$LIBUDEV_1" ]; then
    ln -snf "/$LIBDIR/$LIBUDEV_1" "/$LIBDIR/$LIBUDEV_0"
  elif [ -f "/usr/$LIBDIR/$LIBUDEV_1" ];
  then
    ln -snf "/usr/$LIBDIR/$LIBUDEV_1" "/$LIBDIR/$LIBUDEV_0"
  else
    echo "$LIBUDEV_1" not found in "$LIBDIR" or "/usr/$LIBDIR".
    exit 1
  fi
}

add_udev_symlinks
